import { CacheKey, CacheTTL } from 'aragami';
import { ApiProperty } from '@nestjs/swagger';
import { IsNotEmpty, IsString } from 'class-validator';

export class TicketReq {
  @CacheKey()
  @IsString()
  @IsNotEmpty()
  @ApiProperty({
    description: 'The ticket ID',
  })
  id: string;
}

@CacheTTL(600000)
export class TicketDto extends TicketReq {
  @IsString()
  @IsNotEmpty()
  @ApiProperty({
    description: 'The ticket content',
  })
  ticket: string;
}
