import { SchemaProperty } from 'schemastery-gen';
import { CreatePluginFactory } from '../src/plugin-factory';
import { DefinePlugin, StarterPlugin, UseEvent } from './utility/decorators';
import { Context } from 'cordis';

class MessageConfig {
  @SchemaProperty()
  msg: string;

  getMsg() {
    return this.msg;
  }
}

declare module 'cordis' {
  interface Events {
    foo1(): string;
    foo2(): string;
  }
}

class Base extends StarterPlugin(MessageConfig) {
  @UseEvent('foo1')
  onMessage() {
    return this.config.getMsg();
  }
}

const Factory = CreatePluginFactory(Base, MessageConfig);

class SpecificConfig {
  @SchemaProperty()
  msg2: string;

  getMsg2() {
    return this.msg2;
  }
}

@DefinePlugin()
class SpecificPlugin extends Factory(SpecificConfig) {
  @UseEvent('foo2')
  onMessage2() {
    return this.config.getMsg2();
  }
}

describe('plugin factory', () => {
  it('should register SpecificPlugin', async () => {
    const app = new Context();
    app.plugin(SpecificPlugin, { msg: 'hello', msg2: 'world' });
    await app.start();
    expect(app.bail('foo1')).toBe('hello');
    expect(app.bail('foo2')).toBe('world');
  });
});
