import { PluginDef } from '../src/plugin-def';
import { Provide, UsePlugin } from '../src/decorators';
import { DefinePlugin, StarterPlugin } from './utility/decorators';
import { Context } from 'cordis';

@Provide('inner')
@DefinePlugin()
class MyInnerPlugin extends StarterPlugin() {}

@DefinePlugin()
class MyPlugin extends StarterPlugin() {
  @UsePlugin()
  loadOnebot() {
    return PluginDef(MyInnerPlugin);
  }
}

@DefinePlugin()
class MyLazyPlugin extends StarterPlugin() {
  @UsePlugin()
  async loadOnebot() {
    await new Promise((resolve) => setTimeout(resolve, 1000));
    return PluginDef(MyInnerPlugin);
  }
}

describe('Inner plugin', () => {
  let app: Context;

  it('should load inner plugin properly', async () => {
    app = new Context();
    await app.start();
    expect(app['inner']).toBeUndefined();
    app.plugin(MyPlugin);
    expect(app['inner']).toBeInstanceOf(MyInnerPlugin);
  });

  it('should wait for plugin to load', async () => {
    app = new Context();
    app.plugin(MyLazyPlugin);
    expect(app['inner']).toBeUndefined();
    await app.start();
    expect(app['inner']).toBeInstanceOf(MyInnerPlugin);
  });
});
