import { Context } from 'cordis';
import { LifecycleEvents, PluginRegistrar } from '../plugin-def';
import { TypeFromClass } from '../def';
import { BasePlugin } from '../registrar';
import { Fork, PluginSchema } from '../decorators';
import { ClassType } from 'schemastery-gen';

export function ParentPlugin<PC extends PluginRegistrar.PluginClass<Context>>(
  child: PC,
) {
  const plugin = class ParentPluginBase
    extends BasePlugin<
      PluginRegistrar.ContextFromPlugin<PC>,
      PluginRegistrar.ExactClassPluginConfig<PC>,
      PluginRegistrar.ClassPluginConfig<PC>
    >
    implements LifecycleEvents
  {
    onFork(instance: TypeFromClass<PC>): void | Promise<void> {}
    onForkDisconnect(instance: TypeFromClass<PC>): void | Promise<void> {}
  };
  const schema = child['Config'] as ClassType<any>;
  if (schema) {
    PluginSchema(schema)(plugin);
  }
  Fork(child)(plugin);
  return plugin;
}

export function ParentPluginSet<
  PC extends PluginRegistrar.PluginClass<Context>,
>(child: PC) {
  return class ParentPluginSet extends ParentPlugin(child) {
    instances = new Set<TypeFromClass<PC>>();

    onFork(instance: TypeFromClass<PC>) {
      this.instances.add(instance);
    }

    onForkDisconnect(instance: TypeFromClass<PC>) {
      this.instances.delete(instance);
    }
  };
}

export function ParentPluginMap<
  PC extends PluginRegistrar.PluginClass<Context>,
  R,
>(child: PC, classifyFunction: (instance: TypeFromClass<PC>) => R) {
  return class ParentPluginMapBase extends ParentPlugin(child) {
    instances = new Map<R, TypeFromClass<PC>>();

    onFork(instance: TypeFromClass<PC>) {
      this.instances.set(classifyFunction(instance), instance);
    }

    onForkDisconnect(instance: TypeFromClass<PC>) {
      this.instances.delete(classifyFunction(instance));
    }
  };
}
