import { Context, Plugin } from 'cordis';
import Schema from 'schemastery';
import { ClassType } from 'schemastery-gen';
import type { Registrar } from '../registrar';

// eslint-disable-next-line @typescript-eslint/no-namespace
export namespace PluginRegistrar {
  type Dict<T, K extends keyof any = string> = { [key in K]?: T };
  export type PluginClass<Ctx extends Context, C = any, P = any> = new (
    ctx: Ctx,
    config: C,
  ) => P;

  export type SystemInjectFun<Ctx extends Context> = <T = any>(
    obj: PluginMeta<Ctx, T>,
    cl: PluginClass<Ctx>,
  ) => any;

  export interface PluginRegistrationOptions<Ctx extends Context, T = any> {
    name?: string;
    schema?: Schema<T> | ClassType<T>;
    Config?: Schema<T> | ClassType<T>;
    using?: Registrar.ServiceName<Ctx>[];
    reusable?: boolean;
  }

  export interface PluginMeta<Ctx extends Context, T = any> {
    __ctx: Ctx;
    __config: T;
    __pluginOptions: PluginRegistrationOptions<Ctx, T>;
    __promisesToWaitFor: Promise<void>[];
    __disposables: (() => void)[];
  }

  export type PluginOptions<T extends Plugin> = boolean | Plugin.Config<T>;

  export interface PluginDefinitionExact<
    Ctx extends Context,
    T extends Plugin<Ctx>,
  > {
    plugin: T;
    options?: boolean | PluginOptions<T>;
  }

  export interface PluginDefinitionName {
    plugin: string;
    options?: any;
  }

  export type PluginDefinition<Ctx extends Context, T extends Plugin = any> =
    | PluginDefinitionExact<Ctx, T>
    | PluginDefinitionName;

  export type ClassPluginConfig<
    Ctx extends Context,
    P extends PluginClass<Ctx>,
  > = P extends PluginClass<infer C> ? C : never;

  export type ExactClassPluginConfig<
    Ctx extends Context,
    P extends PluginClass<Ctx>,
  > = P extends PluginClass<Ctx, any, { config: infer IC }>
    ? IC
    : ClassPluginConfig<Ctx, P>;

  export type MapPluginToConfig<
    Ctx extends Context,
    M extends Dict<PluginClass<Ctx>>,
  > = {
    [K in keyof M]: ClassPluginConfig<Ctx, M[K]>;
  };

  export type MapPluginToConfigWithSelection<
    Ctx extends Context,
    M extends Dict<PluginClass<Ctx>>,
  > = {
    [K in keyof M]: ClassPluginConfig<Ctx, M[K]> & Selection;
  };
}

export function PluginDef<Ctx extends Context>(
  name: string,
  options?: any,
): PluginRegistrar.PluginDefinitionName;
export function PluginDef<Ctx extends Context, T extends Plugin>(
  plugin: T,
  options?: PluginRegistrar.PluginOptions<T>,
): PluginRegistrar.PluginDefinitionExact<Ctx, T>;
export function PluginDef<Ctx extends Context, T extends Plugin>(
  plugin: T,
  options?: PluginRegistrar.PluginOptions<T>,
): PluginRegistrar.PluginDefinition<Ctx, T> {
  return { plugin, options };
}

export interface LifecycleEvents {
  onApply?(): void;
  onConnect?(): void | Promise<void>;
  onDisconnect?(): void | Promise<void>;
  onFork?(instance: any): void | Promise<void>;
  onForkDisconnect?(instance: any): void | Promise<void>;
}
