import { defaultRegistrar } from '../registrar';
import { Context } from 'cordis';
import { PluginRegistrar } from '../plugin-def';

const pluginDecorators = defaultRegistrar.pluginDecorators();

export const {
  PluginName,
  PluginSchema,
  Reusable,
  Provide,
  InjectContext,
  InjectConfig,
  InjectParent,
  Caller,
} = pluginDecorators;

export const Fork = <Ctx extends Context>(
  fork: PluginRegistrar.PluginClass<Ctx>,
) => pluginDecorators.Fork(fork);

export function Inject(name?: string, addUsing?: boolean): PropertyDecorator;
export function Inject(addUsing?: boolean): PropertyDecorator;
export function Inject(...args: [(string | boolean)?, boolean?]) {
  return pluginDecorators.Inject(...args);
}

export function Internal(): MethodDecorator & PropertyDecorator {
  return (obj, key, des?) => {
    const cls = obj.constructor as Context.MixinOptions;
    const field = des ? 'methods' : 'properties';
    if (!cls[field]) {
      cls[field] = [];
    }
    cls[field].push(key);
  };
}
