import { PluginRegistrar } from '../plugin-def';
import { Context } from 'cordis';
import { ClassType } from 'schemastery-gen';
import { BasePlugin, defaultRegistrar } from '../registrar';

export function getPluginSchema<P extends PluginRegistrar.PluginClass<Context>>(
  plugin: P,
): ClassType<
  P extends BasePlugin<Context, any, infer PC>
    ? PC
    : P extends PluginRegistrar.PluginClass<Context, infer C>
    ? C
    : never
> {
  return (
    plugin['Config'] ||
    plugin['schema'] ||
    defaultRegistrar.reflector.get('CordisPluginPredefineSchema', plugin)
  );
}
