import { PluginSchema } from './decorators';
import { AnyClass, ClassType, Mixin } from 'schemastery-gen';
import { Context } from 'cordis';
import { PluginRegistrar } from './plugin-def';
import PluginClass = PluginRegistrar.PluginClass;
import { PartialDeep } from './def';

export function CreatePluginFactory<
  Ctx extends Context,
  C,
  IC,
  P extends { config: IC },
>(
  basePlugin: PluginClass<Ctx, C, P>,
  baseConfig: ClassType<IC>,
): <S>(specificConfig?: ClassType<S>) => new (
  ctx: Context,
  config: PartialDeep<S> & C,
) => P & {
  config: IC & S;
};
export function CreatePluginFactory<Ctx extends Context>(
  basePlugin: PluginClass<Ctx>,
  baseConfig: AnyClass,
) {
  return (specificConfig: AnyClass) => {
    const plugin = class specificPlugin extends basePlugin {};
    const config = specificConfig
      ? Mixin(specificConfig, baseConfig)
      : baseConfig;
    PluginSchema(config)(plugin);
    return plugin;
  };
}
