import { Inject, PluginName, UsingService, Fork } from '../src/decorators';
import { RegisterSchema, SchemaProperty } from 'schemastery-gen';
import { DefinePlugin, StarterPlugin } from './utility/decorators';

@RegisterSchema()
class Config {
  @SchemaProperty()
  foo: string;
}

describe('InjectUsing', () => {
  @DefinePlugin()
  @UsingService('foo')
  class MyFork extends StarterPlugin(Config) {}

  @PluginName('foo-plugin')
  @UsingService('router')
  @DefinePlugin({ using: ['database'], schema: Config })
  @UsingService('http')
  @Fork(MyFork)
  class MyPlugin extends StarterPlugin(Config) {
    @Inject(true)
    cache: any;

    @Inject('assets', true)
    assets: any;

    @Inject('bots')
    bots: any[];
  }

  it('Should include injected using services', () => {
    expect(MyPlugin.name).toBe('foo-plugin');
    expect(MyPlugin['Config']).toEqual(Config);
    const usingList = (MyPlugin as any).using as string[];
    expect(usingList).toBeInstanceOf(Array);
    expect(usingList.length).toEqual(6);
    expect(usingList.includes('database')).toEqual(true);
    expect(usingList.includes('assets')).toEqual(true);
    expect(usingList.includes('cache')).toEqual(true);
    expect(usingList.includes('router')).toEqual(true);
    expect(usingList.includes('bots')).toEqual(false);
    expect(usingList.includes('http')).toEqual(true);
    expect(usingList.includes('foo')).toEqual(true);
  });
});
