import { DefinePlugin, StarterPlugin, UseEvent } from './utility/decorators';
import { SchemaProperty } from 'schemastery-gen';
import { For, If } from '../src/decorators';
import { Context } from 'cordis';

class MyConfig {
  @SchemaProperty()
  foo: boolean;

  @SchemaProperty({ type: String })
  colors: string[];
}

declare module 'cordis' {
  interface Events<C> {
    foo(): string;
  }
}

@DefinePlugin()
class MyPlugin extends StarterPlugin(MyConfig) {
  @If<MyPlugin>((o) => o.config.foo)
  @UseEvent('foo')
  onFoo() {
    return 'bar';
  }

  @For<MyPlugin>(({ config }) => config.colors.map((color) => ({ color })))
  @If<MyPlugin>((_, def) => def.color !== 'badthing')
  @UseEvent('{{color}}' as any)
  onColor() {
    return 'good';
  }
}

describe('Caller', () => {
  let app: Context;
  beforeEach(async () => {
    app = new Context();
    await app.start();
  });

  it('register with true statement', async () => {
    app.plugin(MyPlugin, { foo: true });
    expect(app.bail('foo')).toBe('bar');
  });

  it('register with false statement', async () => {
    app.plugin(MyPlugin, { foo: false });
    expect(app.bail('foo')).toBeUndefined();
  });

  it('register with array', async () => {
    app.plugin(MyPlugin, { colors: ['red', 'blue', 'badthing'] });
    expect(app.bail('red' as any)).toBe('good');
    expect(app.bail('blue' as any)).toBe('good');
    expect(app.bail('badthing' as any)).toBeUndefined();
  });
});
