import { Context } from 'cordis';
import { RegisterSchema, SchemaProperty } from 'schemastery-gen';
import { Reactive } from '../src/decorators';
import { DefinePlugin, StarterPlugin, UseEvent } from './utility/decorators';

declare module 'cordis' {
  interface Events {
    hello(): string;
    hi(): string;
  }
}

@RegisterSchema()
class Config {
  @SchemaProperty()
  name: string;

  getName() {
    return this.name;
  }
}

@Reactive()
@DefinePlugin()
class MyPlugin extends StarterPlugin(Config) {
  @UseEvent('hello')
  onHello() {
    return `My name is ${this.config.getName()}`;
  }

  @UseEvent('hi')
  onHi() {
    return `My name is ${this.config.name}`;
  }
}

describe('reactive', () => {
  it('should handle reactive plugin', async () => {
    const app = new Context();
    app.plugin(MyPlugin, { name: 'Yuzu' });
    await app.start();
    expect(app.bail('hello')).toBe('My name is Yuzu');
    expect(app.bail('hi')).toBe('My name is Yuzu');
  });
});
