import { Inject, Internal, Provide } from '../src/decorators';
import { DefinePlugin, StarterPlugin } from './utility/decorators';
import { Context } from 'cordis';

declare module 'cordis' {
  // eslint-disable-next-line @typescript-eslint/no-namespace
  interface Context {
    foo: string;
    bar(): number;
    bar2(): number;
    bazz: MyProvider;
    myBarConsumer: MyConsumer;
  }
}

@Provide('bazz', { immediate: true })
@DefinePlugin()
class MyProvider extends StarterPlugin() {
  barValue = 5;
  @Internal()
  foo: string;
  @Internal()
  bar() {
    return this.barValue;
  }
}
@Provide('myBarConsumer', { immediate: true })
@DefinePlugin()
class MyConsumer extends StarterPlugin() {
  @Inject()
  bar: Context['bar'];
}

describe('Mixin', () => {
  let app: Context;
  beforeEach(() => {
    app = new Context();
    app.plugin(MyProvider);
    app.plugin(MyConsumer);
  });

  it('should load provide mixin', () => {
    app.foo = 'msg';
    expect(app.foo).toBe('msg');
    expect(app.bar()).toBe(5);
    expect(app.bazz.foo).toBe('msg');
    expect(app.bazz.bar()).toBe(5);

    expect(app.myBarConsumer.bar()).toBe(5);
  });
});
