import { Internal, Provide } from '../src/decorators';
import { DefinePlugin, StarterPlugin } from './utility/decorators';
import { Context } from 'cordis';

declare module 'cordis' {
  // eslint-disable-next-line @typescript-eslint/no-namespace
  interface Context {
    foo: string;
    bar(): number;
    baz: MyInternalService;
  }
}

@Provide('baz', { internal: true })
@DefinePlugin()
class MyInternalService extends StarterPlugin() {
  @Internal()
  foo: string;
  @Internal()
  bar() {
    return 5;
  }
}

describe('Internal service', () => {
  let app: Context;
  beforeEach(() => {
    app = new Context();
  });

  it('should load internal service', () => {
    app.foo = 'msg';
    expect(app.foo).toBe('msg');
    expect(app.bar()).toBe(5);
    expect(app.baz.foo).toBe('msg');
    expect(app.baz.bar()).toBe(5);
  });
});
