import { RegisterSchema, SchemaProperty } from 'schemastery-gen';
import { Accept } from '../src/decorators';
import { DefinePlugin, StarterPlugin, UseEvent } from './utility/decorators';
import { Context } from 'cordis';
import { defaultRegistrar } from '../src/registrar';

@RegisterSchema()
class Config {
  updated = false;

  @SchemaProperty()
  @Accept()
  name: string;

  @SchemaProperty()
  age: number;

  @Accept()
  onUpdate() {
    this.updated = true;
    return false;
  }
}

@DefinePlugin()
class MyPlugin extends StarterPlugin(Config) {
  @UseEvent('hi')
  onHi() {
    return `My name is ${this.config.name} and I'm ${this.config.age} years old`;
  }
}

describe('accept', () => {
  it('should have all types of acceptors', async () => {
    const acceptors = defaultRegistrar.getConfigAcceptors(Config);
    expect(acceptors.length).toBe(2);
  });

  it('should handle reactive plugin', async () => {
    const app = new Context();
    const state = app.plugin(MyPlugin, {
      name: 'Yuzu',
      age: 18,
      updated: false,
    });
    await app.start();
    expect(app.bail('hi')).toBe(`My name is Yuzu and I'm 18 years old`);
    expect(state.config.updated).toBe(false);
    state.update({ name: 'Miya', age: 19 });
    expect(state.config.updated).toBe(true);
    expect(app.bail('hi')).toBe(`My name is Miya and I'm 19 years old`);
  });
});
