import Mustache from 'mustache';
import { ParamRenderer } from '../def';
import { mapValues } from './utility';

export function renderObject<T = any>(
  object: T,
  view: any,
  visited?: Set<any>,
): T;
export function renderObject(object: any, view: any, visited: Set<any>): any {
  if (!view || !object) {
    return object;
  }
  visited ??= new Set();
  if (typeof object === 'string') {
    return Mustache.render(object, view, undefined, { escape: (v) => v });
  }
  if (visited.has(object)) {
    return object;
  }
  if (Array.isArray(object)) {
    visited.add(object);
    return (object as any[]).map((item) => renderObject(item, view, visited));
  }
  if (typeof object === 'object') {
    visited.add(object);
    return mapValues(object, (value) => renderObject(value, view, visited));
  }
  return object;
}

export function generateRenderer(view: any): ParamRenderer {
  return (v) => renderObject(v, view);
}
