import { renderObject } from './render-object';
import { FunctionParams, FunctionReturn } from '../def';

export class RegisterMeta<F extends (...args: any[]) => any, I = any> {
  constructor(public action: F, public args: any[], public info?: I) {}

  run(view: any, ...extras: FunctionParams<F>): FunctionReturn<F> {
    return this.action(...extras, ...renderObject(this.args, view));
  }
}
