import { DefinePlugin, StarterPlugin, UseEvent } from './utility/decorators';
import { Provide, Reusable, UsingService } from '../src/decorators';
import { Context } from 'cordis';

declare module 'cordis' {
  interface Events<C> {
    foo(): string;
  }
}

@Provide('foo')
@DefinePlugin()
class MyProvider extends StarterPlugin() {}

@Reusable()
@DefinePlugin()
class MyPlugin extends StarterPlugin() {
  @UsingService('foo')
  @UseEvent('foo')
  onFoo() {
    return 'bar';
  }
}

describe('Partial using service', () => {
  it('should trigger when available', async () => {
    const app = new Context();
    await app.start();
    app.plugin(MyPlugin);
    expect(app.bail('foo')).toBeUndefined();
    const state = app.plugin(MyProvider);
    expect(app.bail('foo')).toBe('bar');
    app.registry.delete(MyProvider);
    expect(app.bail('foo')).toBeUndefined();
    app.plugin(MyProvider);
    expect(app.bail('foo')).toBe('bar');
  });
});
