type AnyFunction = (...args: any[]) => any;

export function extractObjectMethod<T, K extends keyof T>(
  o: T,
  key: K,
): T[K] extends AnyFunction ? T[K] : AnyFunction {
  // eslint-disable-next-line @typescript-eslint/ban-ts-comment
  // @ts-ignore
  return (...args: any[]) => o[key](...args);
}

export function uniq<T>(arr: T[]) {
  return [...new Set(arr)];
}

export function mapValues<T extends Record<string, any>, R>(
  obj: T,
  fn: (v: T[keyof T], k: keyof T) => R,
): Record<keyof T, R> {
  // eslint-disable-next-line @typescript-eslint/ban-ts-comment
  // @ts-ignore
  return Object.fromEntries(Object.entries(obj).map(([k, v]) => [k, fn(v, k)]));
}
