import { defaultRegistrar } from '../registrar';
import { AcceptOptions, Context } from 'cordis';
import { PluginRegistrar } from '../plugin-def';
import { TypedMethodDecorator } from '../def';

const pluginDecorators = defaultRegistrar.pluginDecorators();

export const {
  PluginName,
  PluginSchema,
  Reusable,
  Reactive,
  Provide,
  InjectContext,
  InjectConfig,
  InjectParent,
  Caller,
  AcceptWhen,
} = pluginDecorators;

export const Fork = <Ctx extends Context>(
  fork: PluginRegistrar.PluginClass<Ctx>,
) => pluginDecorators.Fork(fork);

export function Inject(name?: string, addUsing?: boolean): PropertyDecorator;
export function Inject(addUsing?: boolean): PropertyDecorator;
export function Inject(...args: [(string | boolean)?, boolean?]) {
  return pluginDecorators.Inject(...args);
}

export function Internal(): MethodDecorator & PropertyDecorator {
  return (obj, key, des?) => {
    const cls = obj.constructor as Context.MixinOptions;
    const field = des ? 'methods' : 'properties';
    if (!cls[field]) {
      cls[field] = [];
    }
    cls[field].push(key);
  };
}

export function Accept(
  options?: AcceptOptions,
): ClassDecorator &
  TypedMethodDecorator<(...args: any[]) => boolean> &
  PropertyDecorator {
  return (obj, key?, des?) => {
    if (!key) {
      // Class decorator
      return defaultRegistrar.metadata.append('CordisConfigAcceptors', (ctx) =>
        ctx.accept(undefined, options),
      )(obj);
    }
    if (des) {
      // Method decorator
      return defaultRegistrar.metadata.append('CordisConfigAcceptors', (ctx) =>
        ctx.accept((c) => c[key](), options),
      )(obj.constructor);
    }
    // Property decorator
    return defaultRegistrar.metadata.append('CordisConfigAcceptors', (ctx) =>
      ctx.accept([key as string], undefined, options),
    )(obj.constructor);
  };
}

export function Decline(): PropertyDecorator {
  return (obj, key) =>
    defaultRegistrar.metadata.append('CordisConfigAcceptors', (ctx) =>
      ctx.decline([key]),
    )(obj.constructor);
}
