import { Caller, Provide } from '../src/decorators';
import { DefinePlugin, StarterPlugin } from './utility/decorators';
import { Context } from 'cordis';

@Provide('callerTester')
@DefinePlugin()
class CallerTester extends StarterPlugin() {
  @Caller()
  caller: string;
}

declare module 'cordis' {
  // eslint-disable-next-line @typescript-eslint/no-namespace
  interface Context {
    callerTester: CallerTester;
  }
}

describe('Caller', () => {
  let app: Context;
  beforeEach(async () => {
    app = new Context();
    app.plugin(CallerTester);
    await app.start();
  });

  it('should put caller with correct values', async () => {
    const ctx1 = app.extend();
    const ctx2 = app.extend();
    const caller1 = ctx1.callerTester.caller;
    const caller2 = ctx2.callerTester.caller;
    expect(caller1).toEqual(ctx1);
    expect(caller2).toEqual(ctx2);
    expect(app.callerTester.caller).toEqual(app);
  });
});
