export type Awaitable<T> = [T] extends [Promise<unknown>] ? T : T | Promise<T>;

export type TypedMethodDecorator<F extends (...args: any[]) => any> = <
  T extends F,
>(
  // eslint-disable-next-line @typescript-eslint/ban-types
  target: Object,
  propertyKey: string | symbol,
  descriptor: TypedPropertyDescriptor<T>,
) => void;

export type FunctionParam<F extends (...args: any[]) => any> = F extends (
  ...args: infer R
) => any
  ? R
  : never;
export type FunctionReturn<F extends (...args: any[]) => any> = F extends (
  ...args: any[]
) => infer R
  ? R
  : never;

export type PickEventFunction<M, K extends keyof M = keyof M> = M[K] extends (
  ...args: any[]
) => any
  ? (...args: FunctionParam<M[K]>) => Awaitable<FunctionReturn<M[K]>>
  : M[K];

export type ParamRenderer = <T>(v: T) => T;

export interface ControlTypeMap {
  if: boolean;
  for: Iterable<Record<string, any>>;
}

export type Condition<R, T = any, Ext extends any[] = []> = (
  o: T,
  ...ext: Ext
) => R;

export interface ControlType<
  T extends keyof ControlTypeMap = keyof ControlTypeMap,
> {
  type: T;
  condition: Condition<ControlTypeMap[T], any, [Record<string, any>]>;
}

export type TypeFromClass<T> = T extends { new (...args: any[]): infer U }
  ? U
  : never;

export type ParamsFromClass<T> = T extends { new (...args: infer U): any }
  ? U
  : never;

export type Prop<T> = T;

export type PartialDeep<T> = T extends
  | string
  | number
  | bigint
  | boolean
  | null
  | undefined
  | symbol
  | Date
  // eslint-disable-next-line @typescript-eslint/ban-types
  | Function
  ? T | undefined
  : // Arrays, Sets and Maps and their readonly counterparts have their items made
  // deeply partial, but their own instances are left untouched
  T extends Array<infer ArrayType>
  ? Array<PartialDeep<ArrayType>>
  : T extends ReadonlyArray<infer ArrayType>
  ? ReadonlyArray<ArrayType>
  : T extends Set<infer SetType>
  ? Set<PartialDeep<SetType>>
  : T extends ReadonlySet<infer SetType>
  ? ReadonlySet<SetType>
  : T extends Map<infer KeyType, infer ValueType>
  ? Map<PartialDeep<KeyType>, PartialDeep<ValueType>>
  : T extends ReadonlyMap<infer KeyType, infer ValueType>
  ? ReadonlyMap<PartialDeep<KeyType>, PartialDeep<ValueType>>
  : // ...and finally, all other objects.
    {
      [K in keyof T]?: PartialDeep<T[K]>;
    };
