import { Metadata, reflector } from './metadata';
import { makeArray, MayBeArray } from './utility/utility';
import { Awaitable, ClassType, TypedMethodDecorator } from './def';
import { Aragami } from './aragami';

export const WithKey = (
  factory: (param: any, obj: any, key: string) => Awaitable<any> = (param) =>
    param,
) => Metadata.param('AragamiWithKey', factory);
export const WithLockKey = (
  factory: (param: any, obj: any, key: string) => Awaitable<MayBeArray<any>> = (
    param,
    obj,
    key,
  ) => param,
) => Metadata.param('AragamiWithLockKey', factory);

export class WrapDecoratorBuilder {
  constructor(private aragamiFactory: (obj: any) => Awaitable<Aragami>) {}

  build() {
    const { aragamiFactory } = this;
    return {
      UseLock:
        (): TypedMethodDecorator<(...args: any[]) => Promise<any>> =>
        (obj, key, des) => {
          const oldFun = des.value;
          // eslint-disable-next-line @typescript-eslint/ban-ts-comment
          // @ts-ignore
          des.value = async function (...args) {
            const aragami = await aragamiFactory(this);
            const lockKeyParams = reflector.getArray(
              'AragamiWithLockKey',
              this,
              key,
            );
            const keys = (
              await Promise.all(
                lockKeyParams
                  .map(async (fun, i) => {
                    if (!fun) return;
                    const keyResult = (await fun(
                      args[i],
                      this,
                      key as string,
                    )) as MayBeArray<any>;
                    return makeArray(keyResult);
                  })
                  .filter((s) => !!s),
              )
            ).flat();
            return aragami.lock(keys, () => oldFun.apply(this, args));
          };
        },
      UseCache:
        <T>(
          cl: ClassType<T>,
        ): TypedMethodDecorator<(...args: any[]) => Promise<T>> =>
        (obj, key, des) => {
          const oldFun = des.value;
          // eslint-disable-next-line @typescript-eslint/ban-ts-comment
          // @ts-ignore
          des.value = async function (...args) {
            const aragami = await aragamiFactory(this);
            const wrapped = aragami.useCache<T, []>(
              cl,
              () => oldFun.apply(this, args),
              async () => {
                const withKeyParameters = reflector.getArray(
                  'AragamiWithKey',
                  this,
                  key,
                );
                const firstIndex = withKeyParameters.findIndex((f) => f);
                if (firstIndex === -1) {
                  return;
                }
                return withKeyParameters[firstIndex](
                  args[firstIndex],
                  this,
                  key as string,
                );
              },
            );
            return wrapped();
          };
        },
    };
  }
}
