import { AnyClass, ClassType } from '../def';
import { reflector } from '../metadata';

export const dewrapClass = (value: any) => {
  return value;
};

function isClass(target: any) {
  if (typeof target !== 'function') {
    return false;
  }
  return (
    target.constructor === Function &&
    (target === Date || target.toString().startsWith('class '))
  );
}

export const wrapClass = <T>(
  cl: ClassType<T>,
  value: any,
  visited = new Set(),
): T => {
  if (
    !isClass(cl) ||
    value instanceof cl ||
    value == null ||
    visited.has(value)
  ) {
    return value;
  }

  // eslint-disable-next-line @typescript-eslint/ban-ts-comment
  // @ts-ignore
  if (cl === Date) {
    // eslint-disable-next-line @typescript-eslint/ban-ts-comment
    // @ts-ignore
    return new Date(value) as any;
  }

  visited.add(value);

  const instance = new cl();

  const runField = (key: string, val: any) => {
    const meta = reflector.get('AragamiType', cl, key);
    let fieldCl: AnyClass;
    if (meta) {
      fieldCl = meta();
    } else {
      // use design:type
      fieldCl = Reflect.getMetadata('design:type', cl.prototype, key);
    }

    return wrapClass(fieldCl, val, visited);
  };

  for (const key of Object.keys(value)) {
    const field = value[key];
    if (Array.isArray(field)) {
      instance[key] = field.map((v: any) => runField(key, v));
    } else {
      instance[key] = runField(key, field);
    }
  }
  return instance;
};
