import { MetadataSetter, Reflector } from 'typed-reflector';
import { MayBeArray } from './utility/utility';
import { Awaitable } from './def';

interface MetadataMap {
  AragamiCacheTTL: number;
  AragamiCachePrefix: string;
  AragamiCacheKey: (obj: any) => Awaitable<string>;
}

interface MetadataArrayMap {
  AragamiLockKeys: (obj: any) => Awaitable<MayBeArray<string>>;
  AragamiWithKey: (param: any, obj: any, key: string) => Awaitable<string>;
  AragamiWithLockKey: (
    param: any,
    obj: any,
    key: string,
  ) => Awaitable<MayBeArray<string>>;
}

export const Metadata = new MetadataSetter<MetadataMap, MetadataArrayMap>();
export const reflector = new Reflector<MetadataMap, MetadataArrayMap>();
