export class BaseDriver {
  protected usingKey(baseKey: string, key: string): string {
    return `${baseKey}:${key}`;
  }

  async get(baseKey: string, key: string): Promise<Buffer> {
    return;
  }

  async has(baseKey: string, key: string): Promise<boolean> {
    return !!(await this.get(baseKey, key));
  }

  async set(
    baseKey: string,
    key: string,
    value: Buffer,
    ttl: number,
  ): Promise<void> {}

  async del(baseKey: string, key: string): Promise<boolean> {
    return false;
  }

  async keys(baseKey: string): Promise<string[]> {
    return [];
  }

  async values(baseKey: string): Promise<Buffer[]> {
    const keys = await this.keys(baseKey);
    return Promise.all(keys.map((key) => this.get(baseKey, key)));
  }

  async entries(baseKey: string): Promise<[string, Buffer][]> {
    const keys = await this.keys(baseKey);
    return Promise.all(
      keys.map(async (key) => [key, await this.get(baseKey, key)]),
    );
  }

  async clear(baseKey: string) {
    const keys = await this.keys(baseKey);
    await Promise.all(keys.map((key) => this.del(baseKey, key)));
  }

  lock<R>(keys: string[], cb: () => Promise<R>) {
    return cb();
  }

  async destroy(): Promise<void> { }
}
