import { Metadata } from './metadata';

import { Awaitable, TypedMethodDecorator } from './def';
import { MayBeArray } from './utility/utility';

export const CacheTTL = (ttl: number): ClassDecorator & MethodDecorator =>
  Metadata.set('AragamiCacheTTL', ttl);

export const CachePrefix = (prefix: string): ClassDecorator =>
  Metadata.set('AragamiCachePrefix', prefix);

type ObjectFunction<T> = (o: any) => Awaitable<T>;
type ObjectAndKeyFunction<T> = (o: any, key: string) => Awaitable<T>;

const DrainKey =
  <T>(
    decoratorFactory: (cb: ObjectFunction<T>) => ClassDecorator,
    defaultValue: ObjectAndKeyFunction<T>,
  ) =>
  (
    fun: ObjectAndKeyFunction<T> = defaultValue,
  ): PropertyDecorator & TypedMethodDecorator<ObjectFunction<T>> =>
  (obj, key, des?) => {
    let cb: ObjectFunction<T>;
    if (des) {
      // method decorator
      // eslint-disable-next-line @typescript-eslint/ban-ts-comment
      // @ts-ignore
      cb = async (o) => fun(await o[key](), key);
    } else {
      // property decorator
      cb = (o) => fun(o[key], key);
    }
    return decoratorFactory(cb)(obj.constructor);
  };

export const CacheKey = DrainKey<string>(
  (cb) => Metadata.set('AragamiCacheKey', cb),
  (o) => o.toString(),
);
export const LockKey = DrainKey<MayBeArray<string>>(
  (cb) => Metadata.append('AragamiLockKeys', cb),
  (o, key) => `${key}_${o}`,
);
