# Aragami

Another cache ORM.

## Use

```ts
const aragami = new Aragami({
  // Defaults to memory store, but to specify redis property you may use Redis store.
  redis: {
    url: 'redis://localhost:6379',
  }
});

@CachePrefix('user')
@CacheTTL(30000)
class User {
  @CacheKey() // Required. To cache with key of this field. Put a function inside to transform.
  @LockKey() // Specifies a key for lock.
  name: string;
  @LockKey() // Multiple lock keys can be specified.
  age: string;
}

async function main() {
  const user = new User();
  user.name = 'John';
  user.age = '30';
  await aragami.set(user); // Set with specific object.
  const user2 = await aragami.get(User, 'John');
  const keys = await aragami.keys(User);
  const values = await aragami.values(User);
  const entries = await aragami.entries(User);
  await aragami.delete(user2);
  await aragami.clear(User);
  
  // wraps a function with cache.
  const readUser = aragami.wrap(
    User, 
    (name: string) => database.get(name), // For data fetching
    (name) => name, // Specify cache key.
  );
  
  const userFromCache = await readUser('John');
  
  // wraps a function with lock.
  const saveUser = aragami.lock(
    (user: User) => database.save(user), // Lock process
    (user) => [user], // Specify lock key. Can be an array.
  )
  
  await saveUser(user);
}


```
