import { RedisOptions } from 'ioredis';
import { Settings } from '@nanahira/redlock';

export type RedisDriverOptions = RedisOptions & {
  uri?: string;
  lock?: Settings & { duration?: number; prefix?: string };
  queueKey?: string;
};

export interface AragamiOptions {
  redis?: RedisDriverOptions;
  defaultTTL?: number;
}

// eslint-disable-next-line @typescript-eslint/ban-types
export type TypedMethodDecorator<F extends Function> = <T extends F>(
  // eslint-disable-next-line @typescript-eslint/ban-types
  target: Object,
  propertyKey: string | symbol,
  descriptor: TypedPropertyDescriptor<T>,
) => TypedPropertyDescriptor<T> | void;

export type AnyClass = new (...args: any[]) => any;
export type ClassType<T> = new (...args: any[]) => T;
export type Awaitable<T> = T | Promise<T>;
