export class BaseDriver {
  protected usingKey(baseKey: string, key: string): string {
    return `${baseKey}:${key}`;
  }

  async get(baseKey: string, key: string): Promise<Buffer> {
    return;
  }

  async has(baseKey: string, key: string): Promise<boolean> {
    return !!(await this.get(baseKey, key));
  }

  async set(
    baseKey: string,
    key: string,
    value: Buffer,
    ttl: number,
  ): Promise<void> {}

  async del(baseKey: string, key: string): Promise<boolean> {
    return false;
  }

  async keys(baseKey: string, prefix?: string): Promise<string[]> {
    return [];
  }

  async values(baseKey: string, prefix?: string): Promise<Buffer[]> {
    const keys = await this.keys(baseKey, prefix);
    return Promise.all(keys.map((key) => this.get(baseKey, key)));
  }

  async entries(baseKey: string, prefix?: string): Promise<[string, Buffer][]> {
    const keys = await this.keys(baseKey, prefix);
    return Promise.all(
      keys.map(async (key) => [key, await this.get(baseKey, key)]),
    );
  }

  async clear(baseKey: string, prefix?: string) {
    const keys = await this.keys(baseKey, prefix);
    await Promise.all(keys.map((key) => this.del(baseKey, key)));
  }

  lock<R>(keys: string[], cb: () => Promise<R>) {
    return cb();
  }

  async destroy(): Promise<void> {}

  async isQueueEmpty(key: string): Promise<boolean> {
    return (await this.queueLength(key)) === 0;
  }

  async queueLength(key: string): Promise<number> {
    return (await this.queueItems(key)).length;
  }

  async queueItems(key: string): Promise<Buffer[]> {
    return [];
  }

  async queueAdd(key: string, value: Buffer, prior?: boolean): Promise<void> {}

  async queueGather(key: string): Promise<Buffer> {
    return;
  }

  async queueGatherBlocking(key: string): Promise<Buffer> {
    while (true) {
      const value = await this.queueGather(key);
      if (value) {
        return value;
      }
      await new Promise((resolve) => setTimeout(resolve, 10));
    }
  }

  async queueClear(key: string): Promise<void> {}
}
