import axios, {
  AxiosRequestConfig,
  AxiosResponse,
  CreateAxiosDefaults,
} from 'axios';
import { OTTServerResponse } from '../types/server-response';

export class Quester {
  http = axios.create(this.options);
  constructor(private options: CreateAxiosDefaults) {}

  async handleResponse<T>(
    response: Promise<AxiosResponse<OTTServerResponse<T>>>,
  ) {
    const result = await response;
    if (result.data.code >= 300) {
      throw new Error('OTT Server error: ' + result.data.message);
    }
    return result.data.data;
  }

  async get<T>(url: string, options: AxiosRequestConfig) {
    return this.handleResponse(
      this.http.get<OTTServerResponse<T>>(url, options),
    );
  }

  async post<T>(url: string, data: any, options: AxiosRequestConfig) {
    return this.handleResponse(
      this.http.post<OTTServerResponse<T>>(url, data, options),
    );
  }

  async parseDownloadURL(url: string, ip?: string): Promise<string> {
    if (url.includes('?params=')) {
      const params = url.split('?params=')[1];
      const decoded = Buffer.from(params, 'base64').toString('utf-8');
      return this.parseDownloadURL(decoded, ip);
    }
    const tmpLinkReq = await this.http.head(url, {
      maxRedirects: 0,
      validateStatus: (c) => c === 302 || c === 301 || c === 200,
      headers: ip
        ? {
            'X-Forwarded-For': ip,
          }
        : undefined,
    });
    if (tmpLinkReq.status !== 200) {
      return tmpLinkReq.headers.location;
    }
    return url;
  }
}
