import { CacheKey } from 'aragami';
import moment from 'moment';

export class UserToken {
  @CacheKey()
  username: string;

  token: string;

  expiresAt: number;

  isExpired() {
    const now = moment();
    const expiresAt = moment.unix(this.expiresAt);
    return now.isAfter(expiresAt);
  }

  fromLoginResult(username: string, loginResult: LoginResult) {
    this.username = username;
    this.token = loginResult.token;
    this.expiresAt = loginResult.refresh_token_expire_time;
    return this;
  }
}
