import { Command } from 'commander';
import { version, description } from '../package.json';
import { OneTwoThreeShare } from './ott';

const program = new Command();

program.version(version).description(description);

program
  .command('parse')
  .description('Parse a link from 123yun')
  .argument('<link>', 'Link to parse')
  .option('-p, --password <password>', 'Password of the share')
  .option('--client-ip <clientIp>', 'Client IP')
  .action(async (link: string, options) => {
    const ott = new OneTwoThreeShare();
    try {
      const result = (await ott.parse(link, options))[0].DownloadUrl;
      console.log(result);
    } catch (e) {
      console.error(e.message);
      process.exit(1);
    }
  });

program
  .command('create')
  .description('Create a share from a file')
  .argument('<file>', 'File to share')
  .option('-u, --username <username>', 'Username of 123yun')
  .option('-p, --password <password>', 'Password of 123yun')
  .option('-n, --name <name>', 'Name of the share')
  .option('-x, --expire <expire>', 'Expire time of the share')
  .option('-d, --directory <directory>', 'Directory of the share')
  .option('-P, --share-password <password>', 'Share password')
  .option('--concorrency <concorrency>', 'Concorrency of the update process')
  .action(async (file: string, options) => {
    const credentials = {
      username: options.username || process.env.OTT_USERNAME,
      password: options.password || process.env.OTT_PASSWORD,
    };

    if (!credentials.username || !credentials.password) {
      console.error('Username or password is not configured.');
      process.exit(1);
    }

    const directory = parseInt(options.directory || process.env.OTT_DIRECTORY);
    if (!directory) {
      console.error('Directory is not configured.');
      process.exit(1);
    }

    const ott = new OneTwoThreeShare({
      credentials,
      uploadConcurrent: options.concorrency || 3,
    });
    try {
      const result = await ott.create(
        [
          {
            media: file,
          },
        ],
        {
          expiration: options.expire,
          password: options.sharePassword,
          directory,
          name: options.name,
        },
      );
      console.log(result);
    } catch (e) {
      console.error(e.message);
      process.exit(1);
    }
  });

program.parse();
