import { OneTwoThreeShare } from '../src/ott';

describe('Sample test.', () => {
  const ott = new OneTwoThreeShare();

  async function testLink(
    url: string,
    options: OneTwoThreeShare.ParseShareOptions,
  ) {
    const result = (await ott.parse(url, options))[0].DownloadUrl;
    expect(result).toBeDefined();
    console.log(`${url} => ${result}`);
    const visit = await ott.http.http.head(result);
    expect(visit.status).toBe(200);
    expect(visit.headers['content-type']).toBe('application/octet-stream');
  }

  it('should parse share', async () => {
    await testLink('https://www.123pan.com/s/wY88Vv-oTbsd', {});
  });
});
