import { Readable } from 'stream';

export function pickAttributes<T, K extends keyof T>(
  obj: T,
  keys: K[],
): Pick<T, K> {
  const res: any = {};
  keys.forEach((key) => {
    res[key] = obj[key];
  });
  return res;
}

export function bufferToStream(buffer: Buffer): Readable {
  const stream = new Readable();
  stream.push(buffer);
  stream.push(null);
  return stream;
}

export function streamToBuffer(stream: Readable): Promise<Buffer> {
  return new Promise((resolve, reject) => {
    const chunks: Buffer[] = [];
    stream.on('data', (chunk) => chunks.push(chunk));
    stream.on('end', () => resolve(Buffer.concat(chunks)));
    stream.on('error', reject);
  });
}
