// eslint-disable-next-line @typescript-eslint/no-namespace
export namespace Uploads {
  export interface FileInfo {
    FileId: number;
    FileName: string;
    Type: number;
    Size: number;
    ContentType: string;
    S3KeyFlag: string;
    CreateAt: string;
    UpdateAt: string;
    Hidden: boolean;
    Etag: string;
    Status: number;
    ParentFileId: number;
    Category: number;
    PunishFlag: number;
    ParentName: string;
    DownloadUrl: string;
  }

  export interface CompleteReq {
    Info?: FileInfo;
  }

  export interface Req extends CompleteReq {
    AccessKeyId: string;
    SecretAccessKey: string;
    SessionToken: string;
    Expiration: string;
    Key: string;
    Bucket: string;
    FileId: number;
    Reuse: boolean;
    UploadId: string;
    DownloadUrl: string;
  }
}
