#!/bin/bash
set -x
set -o errexit

export JP_DATABASE_PATH="./mats/ygopro-database/locales/ja-JP/cards.cdb"
export SOURCE_TARGET_PATH="./mats/ygopro-database/locales/$LOCALE/cards.cdb"
export LFLIST_PATH="./mats/lflist.conf"
export CARD_LIST_DATABASE_PATH="./mats/pack.db"
if [ -z "$OUTPUT_SYMBOL" ]; then
  export OUTPUT_SYMBOL="$FILE_SYMBOL"
fi
export OUTPUT_PATH="./output/$OUTPUT_SYMBOL-$LOCALE"

# apt update ; apt -y install sqlite3

npm run "$NPM_SCRIPT"

cp -rf ./extras/$OUTPUT_SYMBOL/injects/* "$OUTPUT_PATH/" || true

cd "$OUTPUT_PATH"
tar zcvf "../$OUTPUT_SYMBOL-data-$LOCALE.tar.gz" deck expansions
7z a -mx9 "../$OUTPUT_SYMBOL-data-$LOCALE.zip" deck expansions
7z a -mx9 "../$OUTPUT_SYMBOL-data-$LOCALE.7z" deck expansions

cd expansions
7z a -mx9 ../../$OUTPUT_SYMBOL-expansions-$LOCALE-ypk.zip *
cd ../..

mv $OUTPUT_SYMBOL-expansions-$LOCALE-ypk.zip $OUTPUT_SYMBOL-expansions-$LOCALE.ypk
