import { DBReader } from "./src/dbreader";
import _ from "lodash";
import { PackDbFetcher } from "./src/packdbfetcher";
import axios from "axios";
import { Banlist, mergeBanlists, readLFList } from "./src/utility";
import moment from "moment";
import fs from 'fs';

const DATE = process.env.DATE;

async function getBanlist() {
	const lflistReq = await axios.get<string>("https://cdn02.moecube.com:444/ygopro-database/zh-CN/lflist.conf", {
		responseType: 'document'
	});
	const lflists = (await readLFList(lflistReq.data)).filter(l => !l.name.includes('TCG')).map(l => ({
		...l,
		date: moment(l.name.split(' ')[0], 'YYYY.MM')
	})).filter(l => l.date.isBefore(DATE));
	const lflist = _.maxBy(lflists, l => l.date.unix());
	const extraLflistPath = `./extras/${process.env.FILE_SYMBOL}/lflist.conf`;
	let extraLflist: Banlist;
	try {
		const extraLflistContent = await fs.promises.readFile(extraLflistPath, 'utf-8');
		extraLflist = (await readLFList(extraLflistContent))[0];
	} catch (e) { }
	return (lflist && extraLflist) ? mergeBanlists([lflist, extraLflist]) : lflist || extraLflist;
}

async function main() {
	const dbreader = new DBReader({
		name: "Database",
		//level: Logger.DEBUG
	});
	await dbreader.init();
	const cards = await PackDbFetcher.fetchOnce(dbreader, `date <= '${DATE}'`);
	console.log(cards.length);
	
	const extraBanlist = await getBanlist();
	await dbreader.run(cards, {
		extraBanlists: extraBanlist ? [extraBanlist] : undefined,
	});
	process.exit();
}
main();
