import Base from "./base";
import axios, { AxiosInstance } from "axios";
import { Card } from "./dbreader";
import { Agent } from "https";

export class CNOCGFetcher extends Base { 
	static async fetchOnce() {
		const fetcher = new CNOCGFetcher({ name: "Temp NW Fetcher" });
		await fetcher.init();
		return await fetcher.fetch();
	}
	static async fetchCodeOnce() {
		const fetcher = new CNOCGFetcher({ name: "Temp NW Fetcher" });
		await fetcher.init();
		return await fetcher.fetchCode();
	}
	axiosInstance: AxiosInstance;
	async init() {
		await super.init();
		this.axiosInstance = axios.create({
			httpsAgent: new Agent({
				rejectUnauthorized: false
			})
		})
	}
	async fetchCode(): Promise<number[]> {
		const allCardStrings: string[] = (await this.axiosInstance.get("https://api.tcgcardgame.com/api/cards/sc", {
			responseType: "json"
		})).data;
		return allCardStrings.map(m => parseInt(m));
	}
	async fetch(): Promise<Card[]> {
		return (await this.fetchCode()).map(m => new Card(m));
	}
}
