#!/bin/bash
set -x
set -o errexit

export JP_DATABASE_PATH="./jp.cdb"
export SOURCE_TARGET_PATH="./ygopro-database/locales/$LOCALE/cards.cdb"
export OUTPUT_PATH="./output/$FILE_SYMBOL-$LOCALE"

apt update ; apt -y install build-essential python3 sqlite3 git tar
git clone --depth=1 https://code.mycard.moe/mycard/ygopro-database
wget -O pack.db https://cdn02.moecube.com:444/ygopro-card-list/pack.db

cp -rf ./ygopro-database/locales/ja-JP/cards.cdb "$JP_DATABASE_PATH"

npm ci
npm run build
npm run "$NPM_SCRIPT"

cp -rf ./extras/$FILE_SYMBOL/injects/* "$OUTPUT_PATH/" || true

cd "$OUTPUT_PATH"
tar zcvf "../$FILE_SYMBOL-data-$LOCALE.tar.gz" deck expansions
cd ..
