import { DBReader } from "./src/dbreader";
import { CNFetcher } from "./src/fetcher";
import _ from "underscore";

async function fetchCardsFromNW(dbreader: DBReader) {
	const fetcher = new CNFetcher({ name: "Fetcher", level: "debug" });
	await fetcher.init();
	const strings = await fetcher.fetch();
	return await dbreader.getAllCardsFromJapaneseNames(strings);
}

async function main() {
	const dbreader = new DBReader({ name: "Database", level: "debug" });
	await dbreader.init();
	const cards = await fetchCardsFromNW(dbreader);
	await dbreader.run(cards);
	process.exit();
}
main();
