import _ from "lodash";
import Base from "./base";
import { Card, DBReader } from "./dbreader";

export class PackDbFetcher extends Base { 
  static async fetchOnce(dbreader: DBReader, cardListCondition?: string) {
		const fetcher = new PackDbFetcher({ name: "Pack DB Fetcher", level: 'info' });
		await fetcher.init();
		return await fetcher.fetch(dbreader, cardListCondition);
  }
  
  async fetch(dbreader: DBReader, cardListCondition?: string) {
    const packDb = await dbreader.openDatabase(this.config.cardListDatabasePath);
    const packDbData = await packDb.all<{ id: number, pack_id: string, date: string }[]>("SELECT id FROM pack" + (cardListCondition ? ` WHERE ${cardListCondition}` : ""));
    return packDbData.map(m => new Card(m.id));
  }
}
