#!/bin/bash
set -x
set -o errexit

export JP_DATABASE_PATH="./jp.cdb"
export SOURCE_TARGET_PATH="./ygopro-database/locales/$LOCALE/cards.cdb"
export OUTPUT_PATH="./output/$LOCALE"

apt update ; apt -y install build-essential python3 sqlite3 git tar
git clone --depth=1 https://code.mycard.moe/mycard/ygopro-database

cp -rf ./ygopro-database/locales/ja-JP/cards.cdb "$JP_DATABASE_PATH"

npm ci
npm run build
npm start

cd "$OUTPUT_PATH"
tar zcvf "../cn-data-$LOCALE.tar.gz" deck expansions
cd ..
