import fs from "fs";
import yaml from "yaml";

export interface Config {
	postDepth: number;
	jpDatabasePath: string;
	cnDatabasePath: string;
	overrideTextDbPath: string;
	cardListDatabasePath: string;
	outputPath: string;
	descSymbol: string;
	fileSymbol: string;
	// cardListCondition?: string;
}

export async function loadConfig(): Promise<Config> {
	// return yaml.parse(await fs.promises.readFile("./config.yaml", "utf-8"));
	return {
		postDepth: process.env.POST_DEPTH ? parseInt(process.env.POST_DEPTH) : 5,
		jpDatabasePath: process.env.JP_DATABASE_PATH || "./ygopro-database/locales/ja-JP/cards.cdb",
		cnDatabasePath: process.env.SOURCE_TARGET_PATH || "./ygopro-database/locales/zh-CN/cards.cdb",
		overrideTextDbPath: process.env.OVERRIDE_TEXT_DB_PATH || "",
		cardListDatabasePath: process.env.CARD_LIST_DATABASE_PATH || "./pack.db",
		outputPath: process.env.OUTPUT_PATH || "./output",
		descSymbol: process.env.CARD_SYMBOL || "简体中文卡",
		fileSymbol: process.env.FILE_SYMBOL || "cn",
		// cardListCondition: process.env.CARD_LIST_CONDITION,
	}
}
