import Base from "./base";
import axios, { AxiosInstance } from "axios";
import { Card } from "./dbreader";
import { Agent } from "https";

export class CNOCGFetcher extends Base { 
	static async fetchOnce() {
		const fetcher = new CNOCGFetcher({ name: "Temp NW Fetcher" });
		await fetcher.init();
		return await fetcher.fetch();
	}
	axiosInstance: AxiosInstance;
	async init() {
		await super.init();
		this.axiosInstance = axios.create({
			httpsAgent: new Agent({
				rejectUnauthorized: false
			})
		})
	}
	async fetch(): Promise<Card[]> {
		this.log.debug(`Started fetching from CNOCG source...`);
		const allCardStrings: string[] = (await this.axiosInstance.get("https://api.tcgcardgame.com/api/cards/sc", {
			responseType: "json"
		})).data;
		const allCards = allCardStrings.map(m => new Card(parseInt(m)));
		return allCards;
	}
}
